/**
 * The main class for the baccarat application.
 *
 * @author CS149 Professors
 * @version 13 November 2017
 */
public class Casino {

   /**
    * The entry point of the application. The mode can be controlled using the
    * options -gui or -console and the BaccaratShoe can be controlled with the
    * option -test.
    *
    * @param args The command-line argumentr
    */
   public static void main(String[] args) {

      BaccaratCroupier croupier;
      BaccaratTable table;
      BaccaratShoe shoe;

      // Construct the BaccaratTable
      if (Keys.contains("-gui", args)) {
         table = new BaccaratTable(true);
      } else {
         table = new BaccaratTable(false);
      }
      table.open();

      // Construct the BaccaratShoe
      if (Keys.contains("-test", args)) {
         shoe = new BaccaratShoe(0);
      } else {
         shoe = new BaccaratShoe(8);
      }

      // Play games (until told not to)
      do {
         croupier = new BaccaratCroupier(table, shoe);
         croupier.start();
      } while (shoe.containsAtLeast(6) && table.promptForYesNo());

      table.close();
   }
}
