/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BaccaratTable
extends JPanel {
    private static final double ASPECT = 0.6428571428571429;
    private static final Color FELT_COLOR = new Color(29, 119, 20);
    private static final long serialVersionUID = 1L;
    private static final String CLUB = "\u2663";
    private static final String DIAMOND = "\u2666";
    private static final String HEART = "\u2665";
    private static final String SPADE = "\u2660";
    private static final String BACCARAT = "\u2663\u2666Baccarat\u2665\u2660";
    private static final String OK_MESSAGE = "Press OK to continue.";
    private static final String YN_MESSAGE = "Play again?";
    private boolean gui;
    private double height;
    private double width;
    private Font[] fonts;
    private FontMetrics fm;
    private Hand banker;
    private Hand player;
    private int lineHeight;
    private int bankerValue;
    private int playerValue;
    private Map<String, Color> colors;
    private Map<String, String> suits = new HashMap<String, String>();
    private String outcome;
    private JDialog okDialog;
    private JDialog ynDialog;
    private JFrame window;
    private JOptionPane okOptionPane;
    private JOptionPane ynOptionPane;
    private Scanner keyboard;

    public BaccaratTable() {
        this(false);
    }

    public BaccaratTable(boolean bl) {
        this.suits.put("C", CLUB);
        this.suits.put("D", DIAMOND);
        this.suits.put("H", HEART);
        this.suits.put("S", SPADE);
        this.colors = new HashMap<String, Color>();
        this.colors.put("C", Color.BLACK);
        this.colors.put("D", Color.RED);
        this.colors.put("H", Color.RED);
        this.colors.put("S", Color.BLACK);
        this.gui = bl;
        this.banker = new Hand(3);
        this.player = new Hand(3);
        if (bl) {
            this.fonts = new Font[200];
            for (int i = 0; i < this.fonts.length; ++i) {
                this.fonts[i] = new Font("Serif", 0, i);
            }
            this.window = new JFrame();
            this.window.setDefaultCloseOperation(0);
            this.window.setSize(600, 400);
            this.window.setContentPane(this);
            this.okOptionPane = new JOptionPane(OK_MESSAGE, -1);
            this.okDialog = this.okOptionPane.createDialog(this, "Waiting...");
            this.ynOptionPane = new JOptionPane(YN_MESSAGE, 3, 0);
            this.ynDialog = this.ynOptionPane.createDialog(this, "Waiting...");
        } else {
            this.keyboard = new Scanner(System.in);
        }
        this.clear();
    }

    private double[] cardSize() {
        double d = this.width / 10.0;
        double d2 = this.height / 4.0;
        if (d / d2 < 0.6428571428571429) {
            d2 = d / 0.6428571428571429;
        } else {
            d = d2 * 0.6428571428571429;
        }
        double[] dArray = new double[]{d, d2, d / 5.0};
        return dArray;
    }

    public void clear() {
        this.player.clear();
        this.banker.clear();
        this.playerValue = -1;
        this.bankerValue = -1;
        this.outcome = null;
        if (this.gui) {
            this.window.setTitle("Baccarat");
            this.repaint();
        }
    }

    public void close() {
        if (this.gui) {
            this.window.setVisible(false);
            this.window.dispose();
        }
    }

    public void open() {
        if (this.gui) {
            this.window.setVisible(true);
        }
    }

    private void paintCard(Card card, int n, int n2, Graphics2D graphics2D) {
        Color color;
        Color color2;
        double[] dArray = this.cardSize();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = d2;
        double d5 = n == 0 ? d3 + (double)n2 * (d + d3) : this.width - d3 - d - (double)(2 - n2) * (d + d3);
        if (card == null) {
            color2 = FELT_COLOR.brighter();
            color = FELT_COLOR.brighter();
        } else {
            color2 = Color.BLACK;
            color = Color.WHITE;
        }
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d5, d4, d, d2, d / 10.0, d / 10.0);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        graphics2D.setColor(color2);
        graphics2D.draw(double_);
        if (card != null) {
            String string = Card.SUITS[card.getSuit()].substring(0, 1);
            String string2 = Card.RANKS[card.getRank()];
            if (string2.length() > 2) {
                string2 = string2.substring(0, 1);
            }
            this.setFontAndRelated(graphics2D, d2 / 4.0);
            graphics2D.setColor(this.colors.get(string));
            graphics2D.drawString(this.suits.get(string), (float)(d5 + 2.0), (float)(d4 + (double)this.lineHeight));
            this.setFontAndRelated(graphics2D, d2 / 2.0);
            double d6 = this.fm.stringWidth(string2);
            graphics2D.drawString(string2, (int)(d5 + d / 2.0 - d6 / 2.0), (int)(d4 + d2 / 2.0 + (double)this.lineHeight / 2.0));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.width = graphics2D.getClip().getBounds2D().getWidth();
        this.height = graphics2D.getClip().getBounds2D().getHeight();
        double[] dArray = this.cardSize();
        graphics2D.setColor(FELT_COLOR);
        graphics2D.fillRect(0, 0, (int)this.width, (int)this.height);
        graphics2D.setColor(FELT_COLOR.brighter());
        this.setFontAndRelated(graphics2D, this.height / 10.0, "Player", (dArray[0] + dArray[2]) * 2.0);
        graphics2D.drawString("Player", (int)dArray[0], (int)(dArray[1] - (double)this.lineHeight / 4.0));
        graphics2D.drawString("Banker", (int)(this.width - (double)this.fm.stringWidth("Banker") - dArray[0]), (int)(dArray[1] - (double)this.lineHeight / 4.0));
        this.setFontAndRelated(graphics2D, this.height / 4.0, BACCARAT, this.width);
        graphics2D.setColor(FELT_COLOR.brighter());
        double d = this.fm.stringWidth(BACCARAT);
        graphics2D.drawString(BACCARAT, (int)(this.width / 2.0 - d / 2.0), (int)(this.height - 2.0));
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.paintCard(null, n, i, graphics2D);
            }
        }
        for (n = 0; n < this.player.size(); ++n) {
            this.paintCard(this.player.getCard(n), 0, n, graphics2D);
        }
        for (n = 0; n < this.banker.size(); ++n) {
            this.paintCard(this.banker.getCard(n), 1, n, graphics2D);
        }
        graphics2D.setColor(Color.BLACK);
        if (this.playerValue >= 0) {
            String string = String.format("%1d", this.playerValue);
            d = this.fm.stringWidth(string);
            graphics2D.drawString(string, (int)(dArray[0] * 1.5 + dArray[2] * 2.0 - d / 2.0), (int)(dArray[1] * 3.0));
        }
        if (this.bankerValue >= 0) {
            String string = String.format("%1d", this.bankerValue);
            d = this.fm.stringWidth(string);
            graphics2D.drawString(string, (int)(this.width - dArray[0] * 1.5 - dArray[2] * 2.0 - d / 2.0), (int)(dArray[1] * 3.0));
        }
        if (this.outcome != null) {
            d = this.fm.stringWidth(this.outcome);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(this.outcome, (int)(this.width / 2.0 - d / 2.0), (int)(dArray[1] * 3.0));
        }
    }

    private void setFontAndRelated(Graphics2D graphics2D, double d, String string, double d2) {
        for (int i = 0; i < this.fonts.length; ++i) {
            graphics2D.setFont(this.fonts[i]);
            this.fm = graphics2D.getFontMetrics();
            this.lineHeight = this.fm.getAscent();
            double d3 = this.fm.stringWidth(string);
            if (this.lineHeight >= (int)d || d3 >= d2) break;
        }
    }

    private void setFontAndRelated(Graphics2D graphics2D, double d) {
        this.setFontAndRelated(graphics2D, d, "", Double.POSITIVE_INFINITY);
    }

    private void printParticipant(String string, Hand hand, int n) {
        System.out.printf("%s: %s", string, hand.toString());
        if (n >= 0) {
            System.out.printf(" (%1d)\n", n);
        } else {
            System.out.printf("\n", new Object[0]);
        }
        System.out.flush();
    }

    public void promptForContinue() {
        if (this.gui) {
            this.okDialog.setVisible(true);
        } else {
            System.out.println("Press [Enter] to continue.");
            this.keyboard.nextLine();
        }
    }

    public boolean promptForYesNo() {
        if (this.gui) {
            this.ynDialog.setVisible(true);
            Object object = this.ynOptionPane.getValue();
            if (object == null) {
                return false;
            }
            return (Integer)object == 0;
        }
        System.out.println(YN_MESSAGE);
        String string = this.keyboard.nextLine();
        if (string == null || string.equals("")) {
            return false;
        }
        return string.substring(0, 1).equalsIgnoreCase("Y");
    }

    public void showBanker(Hand hand, int n) {
        this.banker = hand;
        this.bankerValue = n;
        if (this.gui) {
            this.repaint();
        } else {
            this.printParticipant("Banker", this.banker, this.bankerValue);
        }
    }

    public void showMessage(String string) {
        if (this.gui) {
            this.window.setTitle(string);
        } else {
            System.out.println(string);
            System.out.flush();
        }
    }

    public void showPlayer(Hand hand, int n) {
        this.player = hand;
        this.playerValue = n;
        if (this.gui) {
            this.repaint();
        } else {
            this.printParticipant("Player", this.player, this.playerValue);
        }
    }

    public void showOutcome(String string) {
        this.outcome = string;
        if (this.gui) {
            this.repaint();
        } else {
            System.out.printf("%s\n", string);
            System.out.flush();
        }
    }
}

