/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;

public class BaccaratShoe {
    private ArrayList<Card> cards = new ArrayList();
    private int used = 0;
    private Random rng = new Random();

    public BaccaratShoe(int n) {
        if (n <= 0) {
            this.initializeTestCases();
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < Card.SUITS.length; ++j) {
                    for (int k = 1; k < Card.RANKS.length; ++k) {
                        Card card = new Card(k, j);
                        this.cards.add(card);
                    }
                }
            }
            this.shuffle();
        }
    }

    public boolean containsAtLeast(int n) {
        return this.cards.size() - this.used >= n;
    }

    public Card deal() {
        Card card = null;
        if (this.used < this.cards.size()) {
            card = this.cards.get(this.used);
            ++this.used;
        }
        return card;
    }

    private void initializeTestCases() {
        this.cards.add(new Card("3", "Clubs"));
        this.cards.add(new Card("3", "Diamonds"));
        this.cards.add(new Card("2", "Clubs"));
        this.cards.add(new Card("5", "Clubs"));
        this.cards.add(new Card("4", "Clubs"));
        this.cards.add(new Card("10", "Clubs"));
        this.cards.add(new Card("5", "Diamonds"));
        this.cards.add(new Card("10", "Diamonds"));
        this.cards.add(new Card("9", "Diamonds"));
        this.cards.add(new Card("9", "Spades"));
        this.cards.add(new Card("2", "Diamonds"));
        this.cards.add(new Card("3", "Hearts"));
        this.cards.add(new Card("8", "Hearts"));
        this.cards.add(new Card("7", "Spades"));
        this.cards.add(new Card("8", "Diamonds"));
        this.cards.add(new Card("7", "Hearts"));
        this.cards.add(new Card("5", "Hearts"));
        this.cards.add(new Card("Jack", "Clubs"));
        this.cards.add(new Card("Jack", "Diamonds"));
        this.cards.add(new Card("Ace", "Diamonds"));
        this.cards.add(new Card("King", "Spades"));
        this.cards.add(new Card("6", "Diamonds"));
        this.cards.add(new Card("7", "Hearts"));
        this.cards.add(new Card("3", "Spades"));
        this.cards.add(new Card("Ace", "Clubs"));
        this.cards.add(new Card("3", "Clubs"));
        this.cards.add(new Card("4", "Hearts"));
        this.cards.add(new Card("4", "Spades"));
        this.cards.add(new Card("8", "Clubs"));
        this.cards.add(new Card("4", "Diamonds"));
        this.cards.add(new Card("3", "Hearts"));
        this.cards.add(new Card("9", "Clubs"));
        this.cards.add(new Card("10", "Hearts"));
        this.cards.add(new Card("10", "Spades"));
        this.cards.add(new Card("4", "Clubs"));
        this.cards.add(new Card("10", "Spades"));
        this.cards.add(new Card("2", "Diamonds"));
        this.cards.add(new Card("5", "Hearts"));
        this.cards.add(new Card("King", "Hearts"));
        this.cards.add(new Card("5", "Diamonds"));
        this.cards.add(new Card("King", "Spades"));
        this.cards.add(new Card("8", "Diamonds"));
        this.cards.add(new Card("10", "Hearts"));
        this.cards.add(new Card("9", "Hearts"));
        this.cards.add(new Card("Jack", "Spades"));
    }

    private void shuffle() {
        int n;
        for (int i = n = this.cards.size() - 1; i >= 1; --i) {
            int n2 = this.rng.nextInt(i + 1);
            this.swap(i, n2);
        }
    }

    private void swap(int n, int n2) {
        Card card = this.cards.get(n);
        this.cards.set(n, this.cards.get(n2));
        this.cards.set(n2, card);
    }
}

